<?php
    /**
    *
    * copyright (c) 2013-2018 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    /*
     * questa classe costituisce la base per i visualizzatori dei componenti
     * contiene i metodi di base e quelli per creare la sezione
     */
    class VisualizzatoreComponente {
        private $db;
        
        public function __construct($db) {
            $this->db = $db;
        }
        
        function stampaHtmlComponente($dati,$stampaSezione) {
            if($stampaSezione=="si") {
                $this->creaSezione($dati);
            }
            else {
                $this->generaContenutoSezione($dati);
            }
        }
        
        function creaSezione($dati,$classiAggiuntiveSezione="") {
            if($dati["idElemento"]==0 && $dati["nome"]!="Modulo login/registrati") {
                $this->messaggioDiErrore("Errore nella configurazione del componente {$dati["nome"]}: l'id elemento è impostato a 0");
            }
            else {
                $idSezione     = "";
                $classeSezione = "";
                $codiceColore  = "";
                $codiceImmagineSfondo = "";
                $codiceVideoSfondo    = "";
                $stringaClasseSezione = ControlloreStringhe::rimuoviCaratteriSpeciali(str_replace(" ","",ucwords($dati["nome"])))." {$dati["classeSezione"]} $classiAggiuntiveSezione";
                
                if($dati["idSezione"]!="") {
                    $idSezione = "id=\"{$dati["idSezione"]}\"";
                }
                
                if($dati["coloreSfondo"]!="") {
                    $codiceColore = "style=\"background-color:{$dati["coloreSfondo"]};\"";
                }
                
                if($dati["immagineSfondo"]!="") {
                    $codiceImmagineSfondo = "style=\"background-image:url({$dati["immagineSfondo"]});\"";
                    
                    $classeSezione = "class=\"$stringaClasseSezione background-image\"";
                }
                else {
                    $classeSezione = "class=\"$stringaClasseSezione\"";
                }
                
                if($dati["videoSfondo"]!="") {
                    $arrayVideo           = explode(".",$dati["videoSfondo"]);
                    $estensioneVideo      = $arrayVideo[1];
                    $stringaPoster        = ($dati["immagineSfondo"]!="") ? "poster: {$dati["immagineSfondo"]}" : "";
                    $codiceVideoSfondo    = "data-vide-bg=\"$estensioneVideo: {$dati["videoSfondo"]}, $stringaPoster\" data-vide-options=\"posterType: jpg, loop: true, muted: true, position: 50% 50%\"";
                    $codiceImmagineSfondo = "";
                }
                
                $classeContainer = ($dati["aTuttaLarghezza"]=="si") ? "container-fluid" : "container";
                echo"<section  $idSezione $classeSezione $codiceColore $codiceImmagineSfondo $codiceVideoSfondo>
                        <div class=\"$classeContainer\">
                            <div class=\"row\">";
                                $this->generaContenutoSezione($dati);
                        echo"</div>
                        </div>
                    </section>";
            }
        }
        
        /*
         * questo metodo consente di aggiungere parametri supplementari, prende in
         * input un array di nuovi parametri
         */
        function datiAggiuntivi($arrayCampiAggiuntivi) {

        }
        
        /*
         * questo metodo va sovrascritto dalla sottoclasse con il codice
         * opportuno per il componente specifico che si vuole stampare
         */
        function generaContenutoSezione($dati) {
            
        }
                
        // getter e setter
        function setDb($db) {
            $this->db = $db;
        }

        function getDb() {
            return $this->db;
        }
    }